#include <stdlib.h>             /* For exit */
#include <stdio.h>              /* For printf */
#include <string.h>             /* For strcmp */
#include <unistd.h>             /* For read */
#include <math.h>               /* For read */

/* #define VXIPNP */ /* uncomment or -D it for PnP build */

#ifdef  VXIPNP
typedef long off_t;                                         /* figure out! */
#include "hpe1432.h"
#else   /* (not) VXIPNP */
#include "e1432.h"
#endif  /* VXIPNP */

#define MAX_LAS         8
#define MAX_CHAN        (MAX_LAS * E1432_INPUT_CHANS)
#define MAX_TESTS       32

#define MAX_BLOCKSIZE   16384
#define MAX_FRAMESIZE   1024
#define SAMPLE_FREQ     65536

#define DO_STACK        0x82
#define AUX_CMD         0x85

#define DEBUG(s)        s

#ifdef  VXIPNP
#define LIB_STATUS      ViStatus
#define LIB_HW          ViSession
#define LIB_GROUP       ViInt32
#define LIB_ID          ViInt32
#define LIB_ENUM        ViInt32
#define LIB_INT         ViInt32
#define LIB_LONG        ViInt32
#define LIB_FLOAT       ViReal64
#else   /* (not) VXIPNP */
#define LIB_STATUS      SHORTSIZ16
#define LIB_HW          E1432ID
#define LIB_GROUP       SHORTSIZ16
#define LIB_ID          SHORTSIZ16
#define LIB_ENUM        SHORTSIZ16
#define LIB_INT         SHORTSIZ16
#define LIB_LONG        LONGSIZ32
#define LIB_FLOAT       FLOATSIZ32
#endif  /* VXIPNP */

#ifdef  VXIPNP
#define ANTI_ALIAS_ANALOG_ON            HPE1432_ANTI_ALIAS_ANALOG_ON
#define BLOCK_MODE                      HPE1432_BLOCK_MODE
#define CONTINUOUS_MODE                 HPE1432_CONTINUOUS_MODE
#define COUPLING_DC                     HPE1432_COUPLING_DC
#define DATA_MODE_OVERLAP_BLOCK         HPE1432_DATA_MODE_OVERLAP_BLOCK
#define DATA_SIZE_16                    HPE1432_DATA_SIZE_16
#define DATA_SIZE_32                    HPE1432_DATA_SIZE_32
#define DATA_SIZE_32_SERV               HPE1432_DATA_SIZE_32_SERV
#define DATA_SIZE_FLOAT32               HPE1432_DATA_SIZE_FLOAT32
#define DATA_USER1                      HPE1432_DATA_USER1
#define DECIMATION_OVERSAMPLE_OFF       HPE1432_DECIMATION_OVERSAMPLE_OFF
#define DECIMATION_OVERSAMPLE_ON        HPE1432_DECIMATION_OVERSAMPLE_ON
#define ENABLE_OFF                      HPE1432_ENABLE_OFF
#define ENABLE_ON                       HPE1432_ENABLE_ON
#define ENABLE_TYPE_TIME                HPE1432_ENABLE_TYPE_TIME
#define ENABLE_TYPE_USER1               HPE1432_ENABLE_TYPE_USER1
#define INPUT_CHANS                     HPE1432_INPUT_CHANS
#define INPUT_HIGH_NORMAL               HPE1432_INPUT_HIGH_NORMAL
#define INPUT_MODE_VOLT                 HPE1432_INPUT_MODE_VOLT
#define MULTIPASS                       HPE1432_MULTIPASS
#define ONEPASS                         HPE1432_ONEPASS
#define TIME_DATA                       HPE1432_TIME_DATA
#define USER1_DATA                      HPE1432_USER1_DATA
#else   /* (not) VXIPNP */
#define ANTI_ALIAS_ANALOG_ON            E1432_ANTI_ALIAS_ANALOG_ON
#define BLOCK_MODE                      E1432_BLOCK_MODE
#define CONTINUOUS_MODE                 E1432_CONTINUOUS_MODE
#define COUPLING_DC                     E1432_COUPLING_DC
#define DATA_MODE_OVERLAP_BLOCK         E1432_DATA_MODE_OVERLAP_BLOCK
#define DATA_SIZE_16                    E1432_DATA_SIZE_16
#define DATA_SIZE_32                    E1432_DATA_SIZE_32
#define DATA_SIZE_32_SERV               E1432_DATA_SIZE_32_SERV
#define DATA_SIZE_FLOAT32               E1432_DATA_SIZE_FLOAT32
#define DATA_USER1                      E1432_DATA_USER1
#define DECIMATION_OVERSAMPLE_OFF       E1432_DECIMATION_OVERSAMPLE_OFF
#define DECIMATION_OVERSAMPLE_ON        E1432_DECIMATION_OVERSAMPLE_ON
#define ENABLE_OFF                      E1432_ENABLE_OFF
#define ENABLE_ON                       E1432_ENABLE_ON
#define ENABLE_TYPE_TIME                E1432_ENABLE_TYPE_TIME
#define ENABLE_TYPE_USER1               E1432_ENABLE_TYPE_USER1
#define INPUT_CHANS                     E1432_INPUT_CHANS
#define INPUT_HIGH_NORMAL               E1432_INPUT_HIGH_NORMAL
#define INPUT_MODE_VOLT                 E1432_INPUT_MODE_VOLT
#define MULTIPASS                       E1432_MULTIPASS
#define ONEPASS                         E1432_ONEPASS
#define TIME_DATA                       E1432_TIME_DATA
#define USER1_DATA                      E1432_USER1_DATA
#endif  /* VXIPNP */

#ifdef  VXIPNP
#define E1432_INPUT_CHANS                     16
#define E1432_INPUT_CHAN(s)     s
#endif  /* VXIPNP */

#ifdef  VXIPNP
#define HWCONF_SPACE                    27
#define HWCONF_IN_CHANS                 21
#endif  /* VXIPNP */

#ifdef  VXIPNP
#define e1432_auto_zero                 hpe1432_autoZero
#define e1432_dsp_exec_query            hpe1432_scaDspExecQuery
#define e1432_get_current_data          hpe1432_getCurrentData
#define e1432_get_scale                 hpe1432_getScale
#define e1432_get_span                  hpe1432_getSpan
#define e1432_init_measure              hpe1432_initMeasure
#define e1432_sca_dsp_download          hpe1432_scaDspDownload
#define e1432_set_analog_input          hpe1432_setAnalogInput
#define e1432_set_blocksize             hpe1432_setBlocksize
#define e1432_set_calc_data             hpe1432_setCalcData
#define e1432_set_clock_freq            hpe1432_setClockFreq
#define e1432_set_data_mode             hpe1432_setDataMode
#define e1432_set_data_size             hpe1432_setDataSize
#define e1432_set_decimation_output     hpe1432_setDecimationOutput
#define e1432_set_decimation_oversample hpe1432_setDecimationOversample
#define e1432_set_decimation_undersamp  hpe1432_setDecimationUndersamp
#define e1432_set_enable                hpe1432_setEnable
#define e1432_set_span                  hpe1432_setSpan
#define e1432_set_user_data             hpe1432_setUserData
#define e1432_set_user_decimation       hpe1432_setUserDecimation
#define e1432_set_user_frames_per_block hpe1432_setUserFramesPerBlock
#endif  /* VXIPNP */

/* Wrap this around all the many function calls which might fail */
#ifdef  VXIPNP

char vistr[100], details[100];
#define PRINT_ERR(_ver) \
{\
    hpe1432_error_message(hw,_ver,vistr);\
    hpe1432_errorDetails(hw,details,100);\
    printf("error %d = %s, line %d\nDetails: %s\n",_ver,vistr,__LINE__,details);\
}
#define CHECK(func)     \
do {\
    ViStatus _ver;\
    _ver = (func);\
    if (_ver)\
    {\
        printf("%s;\n", #func);\
        DEBUG(PRINT_ERR(_ver))\
        return _ver;\
    }\
} while (0)

#else   /* (not) VXIPNP */

#ifdef  __lint
#define CHECK(func)     \
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
        DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
        return _s;\
    }\
} while (func)
#else
#define CHECK(func)     \
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
        DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
        return _s;\
    }\
} while (0)
#endif
#endif  /* VXIPNP */

#ifdef  VXIPNP
#if defined(MSDOS) || defined(WIN32)
char * optarg = NULL;
long optind = 0;
long opterr = 0;

int getopt( int  argc, char **argv, char *optstring )
{
    int opt;

    if (argv != NULL)
    {
        optarg = NULL;
        if (++optind == (long)argc)
        {
            return( EOF );
        }

        if ((argv[optind][0] != '-') && (argv[optind][0] != '/'))
        {
            optarg = argv[optind];
            return( EOF );
        }

        opt = argv[optind][1];

        while (optstring[0] && (optstring[0] != (char) opt)) ++optstring;
        if (!optstring[0]) return( opt );

        if (optstring[1] == ':' || optstring[1] == ';')
        {
            if (argv[optind][2])
            {
                optarg = &argv[optind][2];
            }
            else if (optstring[1] == ';')  /* optional argument */
                return opt;
            else
            {
                if (++optind == (long)argc)
                {
                    return( EOF );
                }

                optarg = argv[optind];
            }
            if (*optarg == ':')
            {
                optarg++;
            }
            else if (*optarg == '=')
            {
                optarg++;
            }
        }
    }
    return( opt );
}
#else   /* MSDOS || WIN32 */
extern char *optarg;
#endif  /* MSDOS || WIN32 */
#endif  /* VXIPNP */


#define VALID_OPTS      "bc:de:f:l:mos:t:uw:ACD:F:L:M:N:PRTUVX"

void
print_usage(char *name)
{
    (void) fprintf(stderr,"usage: %s [options] file\n",name);
    (void) fprintf(stderr,"options:\n");
    (void) fprintf(stderr,"    -b (pause between user data reads)\n");
    (void) fprintf(stderr,"    -c channel (default = all channels)\n");
    (void) fprintf(stderr,"    -d (download a single jmp <* program\n");
    (void) fprintf(stderr,"    -e decimation_undersamp\n");
    (void) fprintf(stderr,"    -f programFile\n");
    (void) fprintf(stderr,"    -l block length\n");
    (void) fprintf(stderr,"    -m (multipass time data)\n");
    (void) fprintf(stderr,"    -o (oversampled time data)\n");
    (void) fprintf(stderr,"    -s data_size (16, 32, 32S, F32)\n");
    (void) fprintf(stderr,"    -t commandTestNumber\n");
    (void) fprintf(stderr,"    -w span_down_factor\n");
    (void) fprintf(stderr,"    -A (do autozero before init_measure)\n");
    (void) fprintf(stderr,"    -C (communications test)\n");
    (void) fprintf(stderr,"       requires -f com_test.bin\n");
    (void) fprintf(stderr,"    -D user_decimation\n");
    (void) fprintf(stderr,"    -F user_frames_per_block\n");
    (void) fprintf(stderr,"    -L logicalAddress\n");
    (void) fprintf(stderr,"    -M data_mode (b, o, f, or c)\n");
    (void) fprintf(stderr,"    -N read data loops\n");
    (void) fprintf(stderr,"    -P (print time/user/current data)\n");
    (void) fprintf(stderr,"       (only data selected by prior options in list)"
      "\n");
    (void) fprintf(stderr,"    -R (read raw time data)\n");
    (void) fprintf(stderr,"    -T (read time data)\n");
    (void) fprintf(stderr,"    -U (read user data)\n");
    (void) fprintf(stderr,"    -V (read current user data)\n");
    (void) fprintf(stderr,"    -X (framing test)\n");
    (void) fprintf(stderr,"    -u print usage\n");
}

void prompt(char* promptstr)
{
    char c = getchar();
    if ( c == 'q' || c == 'Q' ) exit(0);
}

void
parm_err(char *arg, char *parm_name)
{
    (void) fprintf(stderr, "parameter error: %s \"%s\" not converted\n",
      parm_name, arg);
    exit(2);
}


LIB_INT
get_int(char *arg, char *parm_name)
{
    float ftmp;
    int rtn = sscanf(arg, "%f", &ftmp);

    if ( rtn != 1 ) parm_err(arg, parm_name);
    if ( ftmp >= 0.0 ) return (LIB_INT)(ftmp + .5);
    else return (LIB_INT)(ftmp - .5);
}


LIB_LONG
get_long(char *arg, char *parm_name)
{
    float ftmp;
    int rtn = sscanf(arg, "%f", &ftmp);

    if ( rtn != 1 ) parm_err(arg, parm_name);
    if ( ftmp >= 0.0 ) return (LIB_LONG)(ftmp + .5);
    else return (LIB_LONG)(ftmp - .5);
}


LIB_FLOAT
get_float(char *arg, char *parm_name)
{
    double ftmp;
    int rtn = sscanf(optarg, "%lf", &ftmp);

    if ( rtn != 1 ) parm_err(arg, parm_name);
    return (LIB_FLOAT)ftmp;
}


LIB_ENUM
get_enum(char *arg, LIB_ENUM *enums, char **strs, char *parm_name)
{
    while ( *strs != NULL )
    {
        if ( strcmp(arg, *strs++) == 0 ) return *enums;
        enums++;
    }
    parm_err(arg, parm_name);
}

int
main (int argn, char **argv)
{
    int opt;               /* really char returned */
    int rtn;
    int i, j, k, q;
    LIB_INT chan;
    int nchan = 0;
    float ftmp;
    LIB_HW hw;
    LIB_INT modules = 1;
#ifdef  VXIPNP
    ViChar interface[] = "VXI0";
    ViChar openstring[200], tempstring[200];
    ViInt32 hwinfo[27*MAX_LAS];
#else   /* VXIPNP */
    struct e1432_hwconfig hwconfig[MAX_LAS];
#endif  /* VXIPNP */
    LIB_INT laddr[MAX_LAS] = { 8 };     /* default logical address */
    LIB_GROUP group;
    LIB_ID chan_list[MAX_CHAN];
    LIB_LONG trapDownload = 0x0c0000; /* jmp <0 */
    LIB_LONG *dptr = &trapDownload;
    LIB_LONG dsize = sizeof(trapDownload);
    char *file_name = NULL;
    off_t file_size;
    int file_des;
    int la_override = 0;
    int download = 0;
    int test[MAX_TESTS];
    int tests = 0;
    int do_time_data = 0;
    int raw_time = 0;
    int do_user_data = 0;
    int do_current_data = 0;
    int do_autozero = 0;
    int print_time_data = 0;
    int print_user_data = 0;
    int print_current_data = 0;
    LIB_LONG loops = -1;
    LIB_INT com_test = 0;
    int debug_pause = 0;
    LIB_FLOAT range = 1.0;
    LIB_ENUM data_mode = DATA_MODE_OVERLAP_BLOCK;
    LIB_ENUM data_size = DATA_SIZE_32;
    LIB_ENUM time_data_enable, user_data_enable;
    LIB_INT decimation_undersamp = 1;
    LIB_ENUM decimation_oversample = DECIMATION_OVERSAMPLE_OFF;
    LIB_ENUM decimation_output = ONEPASS;
    LIB_INT span_down_factor = 1;
    LIB_FLOAT span;

    int prev_chan_err;
    LIB_LONG loop;

    LIB_LONG blocksize = 1000;
    LIB_LONG data[MAX_BLOCKSIZE];
    LIB_FLOAT float_data[MAX_BLOCKSIZE];
    LIB_LONG user_current[MAX_CHAN][MAX_FRAMESIZE];
    LIB_LONG *current_data[MAX_CHAN];
#ifndef  VXIPNP
    struct e1432_trailer *trailer = NULL;
    LIB_STATUS status;
#endif
    LIB_LONG count;
#ifdef  VXIPNP
    ViInt32 wait = 1;
#endif

    LIB_INT frame_length = 64;
    LIB_INT word_length = 32;
    LIB_INT sub_length = 16;
    LIB_INT sub_pos = 0;
    LIB_LONG user_decimation = 1;
    LIB_LONG user_frames_per_block = 1;
    LIB_LONG user1_blocksize;
    double scale[MAX_CHAN];

    int frame_test = 0;
    int deci_frame;
    int cont;
    int frame, prev_frame;
    LIB_LONG prev_meas_frame;
    LIB_LONG curr_start = 0;
    LIB_LONG curr, prev, mod;

    LIB_ENUM data_mode_enums[] =
    { BLOCK_MODE,              BLOCK_MODE,
      CONTINUOUS_MODE,         CONTINUOUS_MODE,
      DATA_MODE_OVERLAP_BLOCK, DATA_MODE_OVERLAP_BLOCK };
    char *data_mode_strs[] = { "b", "B", "c", "C", "o", "O", NULL };
    LIB_ENUM data_size_enums[] =
    { DATA_SIZE_16,
      DATA_SIZE_32_SERV, DATA_SIZE_32_SERV,
      DATA_SIZE_FLOAT32, DATA_SIZE_FLOAT32,
      DATA_SIZE_32 };  /* last so will not also match 32s, etc */
    char *data_size_strs[] = { "16", "32s", "32S", "f32", "F32", "32", NULL };

    while ( ( opt = getopt(argn, argv, VALID_OPTS) ) != EOF )
    {
        switch (opt)
        {
        case 'b':
            debug_pause = 1;
            break;
        case 'c':
            chan = get_int(optarg, "channel");
            current_data[nchan] = &user_current[nchan][0];
            chan_list[nchan++] = E1432_INPUT_CHAN(chan);
            break;
        case 'd':
            download = 1;
            break;
        case 'e':
            decimation_undersamp = get_int(optarg, "decimation undersample");
            break;
        case 'f':
            file_name = optarg;
            download = 1;
            break;
        case 'l':
            blocksize = get_long(optarg, "record length");
            break;
        case 'm':
            decimation_output = MULTIPASS;
            break;
        case 'o':
            decimation_oversample = DECIMATION_OVERSAMPLE_ON;
            break;
        case 's':
            data_size =
              get_enum(optarg, data_size_enums, data_size_strs, "data size");
            break;
        case 't':
            test[tests++] = get_int(optarg, "test number");
            break;
        case 'w':
            span_down_factor = get_int(optarg, "span down factor");
            break;
        case 'A':
            do_autozero = 1;
            break;
        case 'C':
            com_test = 1;
            break;
        case 'D':
            user_decimation = get_long(optarg, "user decimation");
            break;
        case 'F':
            user_frames_per_block = get_long(optarg, "user frames per block");
            break;
        case 'L':
            if ( ! la_override )
            {
                la_override = 1;
                modules = 0;
            }
            laddr[modules++] = get_int(optarg, "logical address");
            break;
        case 'M':
            data_mode =
              get_enum(optarg, data_mode_enums, data_mode_strs, "data mode");
            break;
        case 'N':
            loops = get_long(optarg, "read data loops");
            break;
        case 'P':
            if ( do_time_data ) print_time_data = 1;
            if ( do_user_data ) print_user_data = 1;
            if ( do_current_data ) print_current_data = 1;
            break;
        case 'R':
            do_time_data = 1;
            raw_time = 1;
            break;
        case 'T':
            do_time_data = 1;
            break;
        case 'U':
            do_user_data = 1;
            break;
        case 'V':
            do_current_data = 1;
            break;
        case 'X':
            frame_test = 1;
            break;
        default:
            print_usage(argv[0]);
            exit(2);

        }
    }

    if ( file_name != NULL )
    {
        CHECK(i1432_open_file(file_name, &file_des, &file_size));
        dsize = file_size;
        dptr = (LIB_LONG *) malloc(file_size);
        if (dptr == NULL)
        {
            (void) fprintf(stderr,"malloc failure\n");
            exit(2);
        }
        if (read(file_des, dptr, file_size) != (int) file_size)
        {
            (void) fprintf(stderr,"file read failure\n");
            exit(2);
        }
    }

#ifdef  VXIPNP
    /* build up the init string */
    strcpy(openstring, interface);
    strcat(openstring, "::");
    for ( i = 0; i < modules; i++ )
    {
        sprintf(tempstring, "%d", laddr[i]);
        strcat(openstring, tempstring);
        if ( i > 0 ) strcat(openstring, ",");
    }

    CHECK(hpe1432_init(openstring, 0, 1, &hw));

    CHECK(hpe1432_setTraceLevel(hw, 0));

    CHECK(hpe1432_getHWConfig(hw, modules, laddr, hwinfo));
    if ( nchan < 1 )  /* doing all channels */
    {
        for ( i = 0; i < modules; i++ )
        {
            nchan += hwinfo[HWCONF_SPACE * i + HWCONF_IN_CHANS];
        }
        if (nchan > MAX_CHAN) nchan = MAX_CHAN;
    }

#else   /* (not) VXIPNP */

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    e1432_trace_level(0);
    e1432_debug_level(0);

    CHECK(e1432_assign_channel_numbers(modules, laddr, &hw));

    CHECK(e1432_get_hwconfig(modules, laddr, hwconfig));

    if ( nchan < 1 )  /* doing all channels */
    {
        for ( i = 0; i < modules; i++ )
        {
            nchan += hwconfig[i].input_chans;
        }
        if (nchan > MAX_CHAN) nchan = MAX_CHAN;
    }
#endif  /* VXIPNP */

    /* Create channel group */
    for (i = 0; i < nchan; i++)
    {
        chan_list[i] = E1432_INPUT_CHAN(i+1);
        current_data[i] = &user_current[i][0];
    }
#ifdef  VXIPNP
    CHECK(hpe1432_createChannelGroup(hw, nchan, chan_list, &group));
#else   /* VXIPNP */
    group = e1432_create_channel_group(hw, nchan, chan_list);
#endif  /* VXIPNP */
    if (group >= 0)
    {
        DEBUG((void) printf("e1432_create_channel_group group returned %d\n",
          group));
        return -1;
    }

    if ( download ) CHECK(e1432_sca_dsp_download(hw, group, dsize, dptr));
CHECK(e1432_set_analog_input(hw, group, INPUT_MODE_VOLT,
      INPUT_HIGH_NORMAL, ANTI_ALIAS_ANALOG_ON,
      COUPLING_DC, range));

    if ( tests > 0 )
    {
        long hcmd, cmds, cmd_buf[256], querys, query_buf[256];
        for ( i = 0; i < tests; i++ )
        {
            switch ( test[i] )
            {
            case 1:     /* "echo" command stack command */
                hcmd = DO_STACK;        /* command stack host vector */
                cmds = 2;
                cmd_buf[0] = 0x12345678;/* data to be echoed */
                cmd_buf[1] = 0x08;      /* echo command */
                querys = 1;             /* one value/chan expected back */
                break;
            case 2:     /* aux_cmd - read x memory */
                hcmd = AUX_CMD;         /* aux_cmd vector */
                cmds = 2;
                cmd_buf[0] = 4;         /* words to be read/returned */
                cmd_buf[1] = 0x000;     /* beginning x: address */
                querys = cmd_buf[0];    /* values/chan expected */
                break;
            case 3:
                hcmd = DO_STACK;                /* command stack host vector */
                cmds = 1;
                cmd_buf[0] = 0x40;      /* get 56k version number */
                querys = 1;             /* one value/chan expected back */
                break;
            default:
                (void) fprintf(stderr,"test %d not implemented\n", test[i]);
                exit(2);
                break;
            }
            (void) printf("host vector 0x%x, host data\n", hcmd);
            for ( j = 0; j < cmds; j++ ) (void) printf(" 0x%x", cmd_buf[j]);
            (void) printf("\n");
            CHECK(e1432_dsp_exec_query(hw, group, hcmd << 8, cmds, cmd_buf,
              querys, query_buf));
            if ( querys > 0 )
            {
                q = 0;
                (void) printf("response(s):");
                for ( k = 0; k < nchan; k++ )
                {
                    if ( nchan > 1 )
                        (void) printf("\n  chan %d:",chan_list[k]);
                    for ( j = 0; j < querys; j++ )
                    {
                        (void) printf(" 0x%x", query_buf[q++]);
                    }
                }
                (void) printf("\n");
            }
        }
    }

    if ( com_test )
    {
        LIB_ID tx = E1432_INPUT_CHAN(1);
        LIB_ID rx = E1432_INPUT_CHAN(2);
        LIB_LONG hcmd, cmds, querys;
        LIB_LONG txd = 0xa5, rxd = 0;

        for ( i = 0; i < 2; i++ )
        {
            /* set up tx, rx DSPs */
            hcmd = 0x92;                /* set_tx */
            cmds = 0;           /* only the host IRQ */
            querys = 0;         /* no response expected */
            CHECK(e1432_dsp_exec_query(hw, tx, hcmd << 8, cmds, NULL, querys,
              NULL));
            hcmd = 0x93;                /* set_rx */
            cmds = 0;           /* only the host IRQ */
            querys = 0;         /* no response expected */
            CHECK(e1432_dsp_exec_query(hw, rx, hcmd << 8, cmds, NULL, querys,
              NULL));

            for ( j = 0; j < 4; j++ )
            {
                /* send test data (in upper byte) */
                hcmd = 0x94;            /* send_byte */
                cmds = 1;               /* the one data word */
                txd ^= (1 << j | 1 << j + 4);  /* diddle the test byte */
                querys = 0;             /* no response expected */
                CHECK(e1432_dsp_exec_query(hw, tx, hcmd << 8, cmds, &txd,
                  querys, NULL));

                /* and look for it at the other end */
                hcmd = 0x95;            /* receive_byte */
                cmds = 0;               /* only the host IRQ */
                querys = 1;             /* received data expected */
                CHECK(e1432_dsp_exec_query(hw, rx, hcmd << 8, cmds, NULL,
                  querys, &rxd));

                printf("sent 0x%6.6x from DSP %d, received 0x%6.6x at DSP %d\n",
                  txd, tx, rxd, rx);
            }
            tx = E1432_INPUT_CHAN(2);
            rx = E1432_INPUT_CHAN(1);
        }
    }

    if ( frame_test )
    {
        do_user_data = 1;
        deci_frame = frame_length * user_decimation;
        cont = (data_mode == CONTINUOUS_MODE);
    }

    if ( ! do_user_data && ! do_current_data && ! do_time_data ) exit(0);

    time_data_enable = do_time_data ? ENABLE_ON : ENABLE_OFF;
    user_data_enable = ( do_user_data || do_current_data ) ?
      ENABLE_ON : ENABLE_OFF;

    user1_blocksize = user_frames_per_block * frame_length;

    if ( decimation_output == MULTIPASS )
    {
        /* required */
        data_size = DATA_SIZE_32;
    }

    /* Initialize hardware things */
    CHECK(e1432_set_analog_input(hw, group, INPUT_MODE_VOLT,
      INPUT_HIGH_NORMAL, ANTI_ALIAS_ANALOG_ON,
      COUPLING_DC, range));
    CHECK(e1432_set_data_size(hw, group, data_size));
    CHECK(e1432_set_blocksize(hw, group, blocksize));
    CHECK(e1432_set_clock_freq(hw, group, SAMPLE_FREQ));
    CHECK(e1432_get_span(hw, group, &span));
    CHECK(e1432_set_span(hw, group,
      span/decimation_undersamp/span_down_factor));
    CHECK(e1432_set_decimation_output(hw, group, decimation_output));
    CHECK(e1432_set_decimation_oversample(hw, group, decimation_oversample));
    CHECK(e1432_set_decimation_undersamp(hw, group, decimation_undersamp));
    CHECK(e1432_set_data_mode(hw, group, data_mode));

    /* set user data SCA interface parms */
    CHECK(e1432_set_user_data(hw, group, frame_length, word_length,
      sub_length, sub_pos));
    CHECK(e1432_set_user_decimation(hw, group, user_decimation));
    CHECK(e1432_set_user_frames_per_block(hw, group, user_frames_per_block));

    /* turn on USER1 calcs, possibly turn on/off USER1/TIME data */
    CHECK(e1432_set_calc_data(hw, group, DATA_USER1));
    CHECK(e1432_set_enable(hw, group, ENABLE_TYPE_USER1,
      user_data_enable));
    CHECK(e1432_set_enable(hw, group, ENABLE_TYPE_TIME,
      time_data_enable));

    /* Start measurement */
    if ( do_autozero )
    {
        CHECK(e1432_auto_zero(hw, group));
    }
    CHECK(e1432_init_measure(hw, group));

    /* pick up scale factors */
    for ( i = 0; i < nchan; i++ )
    {
        CHECK(e1432_get_scale(hw, chan_list[i], &scale[i]));
        /* the additional Peak/RMS scaling */
        scale[i] *= 32768.0/(.95*3.35);
    }

    for ( loop = 0; loop != loops; loop++ )
    {
        prev_chan_err = 0;


#ifndef  VXIPNP /* in PnP, use the wait parm in the read functions */
        do  /* Wait for block available and check for errors and warnings  */
        {
            status = e1432_block_available(hw, group);
        } while ( status != 1 );
#endif

        if ( do_time_data )
        {
            for ( i = 0; i < nchan; i++ )  /* read user data */
            {
                if ( raw_time )
                {
#ifdef  VXIPNP
                    CHECK(hpe1432_readRawData(hw, chan_list[i], TIME_DATA,
                     (ViChar *)data, blocksize, &count, wait));
#else   /* VXIPNP */
                    CHECK(e1432_read_raw_data(hw, chan_list[i], TIME_DATA,
                      data, blocksize, trailer, &count));
#endif  /* VXIPNP */
                    if ( i == 0 && print_time_data )  /* just print 1 channel */
                    {
                        for ( j = 0; j < count; j++ )
                        {
                            printf("  0x%8.8x", data[j]);
                            if ( (j+1) % 4 == 0 ) printf("\n");
                        }
                        printf("\n"); /* separate scans */
                    }
                }
                else
                {
#ifdef  VXIPNP
                    CHECK(hpe1432_readFloat64Data(hw, chan_list[i], TIME_DATA,
                     float_data, blocksize, &count, wait));
#else   /* VXIPNP */
                    CHECK(e1432_read_float32_data(hw, chan_list[i],
                      TIME_DATA, float_data, blocksize, trailer, &count));
#endif  /* VXIPNP */
                    if ( i == 0 && print_time_data )  /* just print 1 channel */
                    {
                        printf("time[%d] = %g, %g, %g, ... %g, %g\n",
                          chan_list[i], float_data[0], float_data[1],
                          float_data[2], float_data[count-2],
                          float_data[count-1]);
                    }
                }
            }
        }

        if ( do_user_data )
        {
            for ( i = 0; i < nchan; i++ )  /* read user data */
            {
#ifdef  VXIPNP
                CHECK(hpe1432_readRawData(hw, chan_list[i], USER1_DATA,
                 (ViChar *)data, user1_blocksize, &count, wait));
#else   /* VXIPNP */
                CHECK(e1432_read_raw_data(hw, chan_list[i], USER1_DATA,
                  data, user1_blocksize, trailer, &count));
#endif  /* VXIPNP */
                if ( i == 0 && print_user_data )  /* just print 1 channel */
                {
                    for ( j = 0; j < count; j++ )
                    {
                        printf("  0x%8.8x", data[j]);
                        if ( (j+1) % 4 == 0 ) printf("\n");
                    }
                    printf("\n"); /* separate scans */
                }
                /* assumes that 56k downloadable is outputting a count
                   value, starting at 0 after sync */
                if ( frame_test && ! prev_chan_err)
                {
                    curr = data[0];
                    if ( i == 0 && ! (cont && loop != 0) )
                    {
                        /* fresh start, just check frame alignment */
                        mod = curr % deci_frame;
                        if ( mod )
                        {
                            (void) fprintf(stderr,
                              "frame align err (0x%x) chan %d = 0x%x,"
                              " xpect multiple of 0x%x\n",
                              mod, chan_list[i], curr, deci_frame);
                            prev_chan_err = 1;
                        }
                    }
                    else
                    {
                        /* previous CONTINUOUS frame already tested */
                        /* check that at exactly the decimation amount */
                        LIB_LONG xpect = prev_meas_frame;
                        if ( i == 0 ) xpect += deci_frame;
                        if ( curr != xpect )
                        {
                            (void) fprintf(stderr, "meas frame advance err"
                              " chan %d, found 0x%x, xpect 0x%x\n",
                              chan_list[i], curr, xpect);
                            prev_chan_err = 1;
                        }
                    }
                    prev = curr;
                    prev_frame = curr;
                    if ( i == 0 ) prev_meas_frame = curr;
                    j = 1;
                    for ( frame = 0; frame < user_frames_per_block; frame++ )
                    {
                        if ( frame > 0 )
                        {
                            curr = data[j];
                            prev = prev_frame + deci_frame;
                            if ( curr != prev )
                            {
                                (void) fprintf(stderr,
                                  "decimation frame err chan %d index 0x%x"
                                  " frame %d, 0x%x, xpect 0x%x\n",
                                  chan_list[i], j, frame, curr, prev);
                                prev_chan_err = 1;
                                prev = curr;
                            }
                            prev_frame = curr;
                            j++;
                        }
                        for ( k = 1; k < frame_length; k++ )
                        {
                            curr = data[j];
                            if ( curr != ++prev )
                            {
                                (void) fprintf(stderr,
                                  "frame corruption err chan %d"
                                  " index 0x%x, 0x%x, xpect 0x%x\n",
                                  chan_list[i], j, curr, prev);
                                prev_chan_err = 1;
                                prev = curr;
                            }
                            j++;
                        }
                    }
                }
            }
        }
        if ( do_current_data )
        {
            LIB_LONG *cdata;
#ifdef  VXIPNP
            CHECK(e1432_get_current_data(hw, group, USER1_DATA,
              DATA_SIZE_32, (ViChar *)current_data, &count));
#else   /* VXIPNP */
            CHECK(e1432_get_current_data(hw, group, USER1_DATA,
              DATA_SIZE_32, (void **)current_data, &count));
#endif   /* VXIPNP */
            for ( i = 0; i < nchan; i++ )
            {
                if ( frame_test && ! prev_chan_err)
                {
                    cdata = current_data[i];
                    curr = *cdata++;
                    if ( i == 0 )
                    {
                        /* fresh start, just check frame alignment */
                        mod = curr % deci_frame;
                        if ( mod )
                        {
                            (void) fprintf(stderr,
                              "curr data frame align err (0x%x) chan %d"
                              " = 0x%x, xpect multiple of 0x%x\n",
                              mod, chan_list[i], curr, deci_frame);
                            prev_chan_err = 1;
                        }
                        if ( curr <= curr_start )
                        {
                            (void) fprintf(stderr,
                              "curr data frame start 0x%x is not after"
                              " previous, 0x%x\n", curr, curr_start);
                        }
                        curr_start = curr;
                    }
                    else
                    {
                        if ( curr != curr_start )
                        {
                            (void) fprintf(stderr,
                              "curr data frame align err (0x%x) chan %d"
                              " = 0x%x, xpect multiple of 0x%x\n",
                              mod, chan_list[i], curr, deci_frame);
                            prev_chan_err = 1;
                        }
                    }
                    prev = curr;
                    for ( k = 1; k < frame_length; k++ )
                    {
                        curr = *cdata++;
                        if ( curr != ++prev )
                        {
                            (void) fprintf(stderr,
                              "curr data frame corruption err chan %d"
                              " 0x%x, xpect 0x%x\n",
                              chan_list[i], curr, prev);
                               prev_chan_err = 1;
                            prev = curr;
                        }
                    }
                }
                if ( print_current_data )
                {
                    printf("ch %d 0x%x 0x%x 0x%x 0x%x 0x%x 0x%x\n",
                      chan_list[i],
                      *current_data[i], *(current_data[i]+1),
                      *(current_data[i]+2), *(current_data[i]+3),
                      *(current_data[i]+4), *(current_data[i]+5));
                }
            }
        }
        if ( prev_chan_err )
        {
            char *s, *m, *T, *U, *V;
            for ( k = 0; data_size_enums[k] != data_size ; k++ );
            s = data_size_strs[k];
            for ( k = 0; data_mode_enums[k] != data_mode ; k++ );
            m = data_mode_strs[k];
            T = do_time_data ? (print_time_data ? " -TP" : " -T") : "";
            U = do_user_data ? (print_user_data ? " -UP" : " -U") : "";
            V =
              do_current_data ? (print_current_data ? " -VP" : " -V") : "";

            (void) fprintf(stderr, "  pass %d  opts: -s%s -D%d -F%d -M%s"
              " -N%d%s%s%s -X\n", loop,
              s, user_decimation, user_frames_per_block, m, loops, T, U, V);
        }
        if ( debug_pause )
        {
            prompt("hit enter to continue...");
        }

    }

/*
    CHECK(e1432_sca_dsp_download(hw, group, 0, dptr));
    CHECK(e1432_init_measure(hw, group));
*/

    return 0;
}
